<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Taskrouter\V1\Workspace;

use Twilio\Options;
use Twilio\Values;

abstract class TaskQueueOptions {
    /**
     * @param string $friendlyName The friendly_name
     * @param string $targetWorkers The target_workers
     * @param string $reservationActivitySid The reservation_activity_sid
     * @param string $assignmentActivitySid The assignment_activity_sid
     * @param string $maxReservedWorkers The max_reserved_workers
     * @return UpdateTaskQueueOptions Options builder
     */
    public static function update($friendlyName = Values::NONE, $targetWorkers = Values::NONE, $reservationActivitySid = Values::NONE, $assignmentActivitySid = Values::NONE, $maxReservedWorkers = Values::NONE) {
        return new UpdateTaskQueueOptions($friendlyName, $targetWorkers, $reservationActivitySid, $assignmentActivitySid, $maxReservedWorkers);
    }

    /**
     * @param string $friendlyName The friendly_name
     * @param string $evaluateWorkerAttributes The evaluate_worker_attributes
     * @return ReadTaskQueueOptions Options builder
     */
    public static function read($friendlyName = Values::NONE, $evaluateWorkerAttributes = Values::NONE) {
        return new ReadTaskQueueOptions($friendlyName, $evaluateWorkerAttributes);
    }

    /**
     * @param string $targetWorkers The target_workers
     * @param string $maxReservedWorkers The max_reserved_workers
     * @return CreateTaskQueueOptions Options builder
     */
    public static function create($targetWorkers = Values::NONE, $maxReservedWorkers = Values::NONE) {
        return new CreateTaskQueueOptions($targetWorkers, $maxReservedWorkers);
    }
}

class UpdateTaskQueueOptions extends Options {
    /**
     * @param string $friendlyName The friendly_name
     * @param string $targetWorkers The target_workers
     * @param string $reservationActivitySid The reservation_activity_sid
     * @param string $assignmentActivitySid The assignment_activity_sid
     * @param string $maxReservedWorkers The max_reserved_workers
     */
    public function __construct($friendlyName = Values::NONE, $targetWorkers = Values::NONE, $reservationActivitySid = Values::NONE, $assignmentActivitySid = Values::NONE, $maxReservedWorkers = Values::NONE) {
        $this->options['friendlyName'] = $friendlyName;
        $this->options['targetWorkers'] = $targetWorkers;
        $this->options['reservationActivitySid'] = $reservationActivitySid;
        $this->options['assignmentActivitySid'] = $assignmentActivitySid;
        $this->options['maxReservedWorkers'] = $maxReservedWorkers;
    }

    /**
     * The friendly_name
     * 
     * @param string $friendlyName The friendly_name
     * @return $this Fluent Builder
     */
    public function setFriendlyName($friendlyName) {
        $this->options['friendlyName'] = $friendlyName;
        return $this;
    }

    /**
     * The target_workers
     * 
     * @param string $targetWorkers The target_workers
     * @return $this Fluent Builder
     */
    public function setTargetWorkers($targetWorkers) {
        $this->options['targetWorkers'] = $targetWorkers;
        return $this;
    }

    /**
     * The reservation_activity_sid
     * 
     * @param string $reservationActivitySid The reservation_activity_sid
     * @return $this Fluent Builder
     */
    public function setReservationActivitySid($reservationActivitySid) {
        $this->options['reservationActivitySid'] = $reservationActivitySid;
        return $this;
    }

    /**
     * The assignment_activity_sid
     * 
     * @param string $assignmentActivitySid The assignment_activity_sid
     * @return $this Fluent Builder
     */
    public function setAssignmentActivitySid($assignmentActivitySid) {
        $this->options['assignmentActivitySid'] = $assignmentActivitySid;
        return $this;
    }

    /**
     * The max_reserved_workers
     * 
     * @param string $maxReservedWorkers The max_reserved_workers
     * @return $this Fluent Builder
     */
    public function setMaxReservedWorkers($maxReservedWorkers) {
        $this->options['maxReservedWorkers'] = $maxReservedWorkers;
        return $this;
    }

    /**
     * Provide a friendly representation
     * 
     * @return string Machine friendly representation
     */
    public function __toString() {
        $options = array();
        foreach ($this->options as $key => $value) {
            if ($value != Values::NONE) {
                $options[] = "$key=$value";
            }
        }
        return '[Twilio.Taskrouter.V1.UpdateTaskQueueOptions ' . implode(' ', $options) . ']';
    }
}

class ReadTaskQueueOptions extends Options {
    /**
     * @param string $friendlyName The friendly_name
     * @param string $evaluateWorkerAttributes The evaluate_worker_attributes
     */
    public function __construct($friendlyName = Values::NONE, $evaluateWorkerAttributes = Values::NONE) {
        $this->options['friendlyName'] = $friendlyName;
        $this->options['evaluateWorkerAttributes'] = $evaluateWorkerAttributes;
    }

    /**
     * The friendly_name
     * 
     * @param string $friendlyName The friendly_name
     * @return $this Fluent Builder
     */
    public function setFriendlyName($friendlyName) {
        $this->options['friendlyName'] = $friendlyName;
        return $this;
    }

    /**
     * The evaluate_worker_attributes
     * 
     * @param string $evaluateWorkerAttributes The evaluate_worker_attributes
     * @return $this Fluent Builder
     */
    public function setEvaluateWorkerAttributes($evaluateWorkerAttributes) {
        $this->options['evaluateWorkerAttributes'] = $evaluateWorkerAttributes;
        return $this;
    }

    /**
     * Provide a friendly representation
     * 
     * @return string Machine friendly representation
     */
    public function __toString() {
        $options = array();
        foreach ($this->options as $key => $value) {
            if ($value != Values::NONE) {
                $options[] = "$key=$value";
            }
        }
        return '[Twilio.Taskrouter.V1.ReadTaskQueueOptions ' . implode(' ', $options) . ']';
    }
}

class CreateTaskQueueOptions extends Options {
    /**
     * @param string $targetWorkers The target_workers
     * @param string $maxReservedWorkers The max_reserved_workers
     */
    public function __construct($targetWorkers = Values::NONE, $maxReservedWorkers = Values::NONE) {
        $this->options['targetWorkers'] = $targetWorkers;
        $this->options['maxReservedWorkers'] = $maxReservedWorkers;
    }

    /**
     * The target_workers
     * 
     * @param string $targetWorkers The target_workers
     * @return $this Fluent Builder
     */
    public function setTargetWorkers($targetWorkers) {
        $this->options['targetWorkers'] = $targetWorkers;
        return $this;
    }

    /**
     * The max_reserved_workers
     * 
     * @param string $maxReservedWorkers The max_reserved_workers
     * @return $this Fluent Builder
     */
    public function setMaxReservedWorkers($maxReservedWorkers) {
        $this->options['maxReservedWorkers'] = $maxReservedWorkers;
        return $this;
    }

    /**
     * Provide a friendly representation
     * 
     * @return string Machine friendly representation
     */
    public function __toString() {
        $options = array();
        foreach ($this->options as $key => $value) {
            if ($value != Values::NONE) {
                $options[] = "$key=$value";
            }
        }
        return '[Twilio.Taskrouter.V1.CreateTaskQueueOptions ' . implode(' ', $options) . ']';
    }
}