<?php
/**
 * Transaction
 *
 * PHP version 5
 *
 * @category Class
 * @package  SquareConnect
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */
/**
 *  Copyright 2016 Square, Inc.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace SquareConnect\Model;

use \ArrayAccess;
/**
 * Transaction Class Doc Comment
 *
 * @category    Class
 * @description Represents a transaction processed with Square, either with the\nConnect API or with Square Register.
 * @package     SquareConnect
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class Transaction implements ArrayAccess
{
    /**
      * Array of property to type mappings. Used for (de)serialization 
      * @var string[]
      */
    static $swaggerTypes = array(
        'id' => 'string',
        'location_id' => 'string',
        'created_at' => 'string',
        'tenders' => '\SquareConnect\Model\Tender[]',
        'refunds' => '\SquareConnect\Model\Refund[]',
        'reference_id' => 'string',
        'product' => 'string'
    );
  
    /** 
      * Array of attributes where the key is the local name, and the value is the original name
      * @var string[] 
      */
    static $attributeMap = array(
        'id' => 'id',
        'location_id' => 'location_id',
        'created_at' => 'created_at',
        'tenders' => 'tenders',
        'refunds' => 'refunds',
        'reference_id' => 'reference_id',
        'product' => 'product'
    );
  
    /**
      * Array of attributes to setter functions (for deserialization of responses)
      * @var string[]
      */
    static $setters = array(
        'id' => 'setId',
        'location_id' => 'setLocationId',
        'created_at' => 'setCreatedAt',
        'tenders' => 'setTenders',
        'refunds' => 'setRefunds',
        'reference_id' => 'setReferenceId',
        'product' => 'setProduct'
    );
  
    /**
      * Array of attributes to getter functions (for serialization of requests)
      * @var string[]
      */
    static $getters = array(
        'id' => 'getId',
        'location_id' => 'getLocationId',
        'created_at' => 'getCreatedAt',
        'tenders' => 'getTenders',
        'refunds' => 'getRefunds',
        'reference_id' => 'getReferenceId',
        'product' => 'getProduct'
    );
  
    
    /**
      * $id The transaction's unique ID.
      * @var string
      */
    protected $id;
    
    /**
      * $location_id The ID of the transaction's associated location.
      * @var string
      */
    protected $location_id;
    
    /**
      * $created_at The time when the transaction was created, in RFC 3339 format.
      * @var string
      */
    protected $created_at;
    
    /**
      * $tenders Descriptions of the tenders used to pay for the transaction.
      * @var \SquareConnect\Model\Tender[]
      */
    protected $tenders;
    
    /**
      * $refunds An array of any refunds associated with the transaction.
      * @var \SquareConnect\Model\Refund[]
      */
    protected $refunds;
    
    /**
      * $reference_id If the transaction was created with the **Charge** endpoint, this\nvalue is the same as the value provided as the `reference_id` parameter\nin the request to that endpoint.
      * @var string
      */
    protected $reference_id;
    
    /**
      * $product The product that processed the transaction.
      * @var string
      */
    protected $product;
    

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        if ($data != null) {
            $this->id = $data["id"];
            $this->location_id = $data["location_id"];
            $this->created_at = $data["created_at"];
            $this->tenders = $data["tenders"];
            $this->refunds = $data["refunds"];
            $this->reference_id = $data["reference_id"];
            $this->product = $data["product"];
        }
    }
    
    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }
  
    /**
     * Sets id
     * @param string $id The transaction's unique ID.
     * @return $this
     */
    public function setId($id)
    {
        
        $this->id = $id;
        return $this;
    }
    
    /**
     * Gets location_id
     * @return string
     */
    public function getLocationId()
    {
        return $this->location_id;
    }
  
    /**
     * Sets location_id
     * @param string $location_id The ID of the transaction's associated location.
     * @return $this
     */
    public function setLocationId($location_id)
    {
        
        $this->location_id = $location_id;
        return $this;
    }
    
    /**
     * Gets created_at
     * @return string
     */
    public function getCreatedAt()
    {
        return $this->created_at;
    }
  
    /**
     * Sets created_at
     * @param string $created_at The time when the transaction was created, in RFC 3339 format.
     * @return $this
     */
    public function setCreatedAt($created_at)
    {
        
        $this->created_at = $created_at;
        return $this;
    }
    
    /**
     * Gets tenders
     * @return \SquareConnect\Model\Tender[]
     */
    public function getTenders()
    {
        return $this->tenders;
    }
  
    /**
     * Sets tenders
     * @param \SquareConnect\Model\Tender[] $tenders Descriptions of the tenders used to pay for the transaction.
     * @return $this
     */
    public function setTenders($tenders)
    {
        
        $this->tenders = $tenders;
        return $this;
    }
    
    /**
     * Gets refunds
     * @return \SquareConnect\Model\Refund[]
     */
    public function getRefunds()
    {
        return $this->refunds;
    }
  
    /**
     * Sets refunds
     * @param \SquareConnect\Model\Refund[] $refunds An array of any refunds associated with the transaction.
     * @return $this
     */
    public function setRefunds($refunds)
    {
        
        $this->refunds = $refunds;
        return $this;
    }
    
    /**
     * Gets reference_id
     * @return string
     */
    public function getReferenceId()
    {
        return $this->reference_id;
    }
  
    /**
     * Sets reference_id
     * @param string $reference_id If the transaction was created with the **Charge** endpoint, this\nvalue is the same as the value provided as the `reference_id` parameter\nin the request to that endpoint.
     * @return $this
     */
    public function setReferenceId($reference_id)
    {
        
        $this->reference_id = $reference_id;
        return $this;
    }
    
    /**
     * Gets product
     * @return string
     */
    public function getProduct()
    {
        return $this->product;
    }
  
    /**
     * Sets product
     * @param string $product The product that processed the transaction.
     * @return $this
     */
    public function setProduct($product)
    {
        $allowed_values = array("REGISTER", "EXTERNAL_API", "BILLING", "APPOINTMENTS", "INVOICES", "ONLINE_STORE", "PAYROLL", "OTHER");
        if (!in_array($product, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'product', must be one of 'REGISTER', 'EXTERNAL_API', 'BILLING', 'APPOINTMENTS', 'INVOICES', 'ONLINE_STORE', 'PAYROLL', 'OTHER'");
        }
        $this->product = $product;
        return $this;
    }
    
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset 
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->$offset);
    }
  
    /**
     * Gets offset.
     * @param  integer $offset Offset 
     * @return mixed 
     */
    public function offsetGet($offset)
    {
        return $this->$offset;
    }
  
    /**
     * Sets value based on offset.
     * @param  integer $offset Offset 
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        $this->$offset = $value;
    }
  
    /**
     * Unsets offset.
     * @param  integer $offset Offset 
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->$offset);
    }
  
    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) {
            return json_encode(\SquareConnect\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        } else {
            return json_encode(\SquareConnect\ObjectSerializer::sanitizeForSerialization($this));
        }
    }
}
